/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import java.util.Arrays;
import java.util.List;
import org.bukkit.util.config.Configuration;

public class Config {
    static List<String> worldNames;
    static List<String> worldTables;
    static String dbDriver;
    static String dbUrl;
    static String dbUsername;
    static String dbPassword;
    static int keepLogDays;
    static int delay;
    static int defaultDist;
    static int defaultTime;
    static int toolID;
    static int toolblockID;
    static boolean toolblockRemove;
    static boolean logSignTexts;
    static boolean logExplosions;
    static boolean logFire;
    static boolean logLeavesDecay;
    static boolean logChestAccess;
    static String logTNTExplosionsAs;
    static String logCreeperExplosionsAs;
    static String logFireAs;
    static String logLeavesDecayAs;
    static boolean usePermissions;

    static boolean Load(Configuration config) {
        config.load();
        List keys = config.getKeys(null);
        if (!keys.contains("worldNames")) {
            config.setProperty("worldNames", Arrays.asList("world"));
        }
        if (!keys.contains("worldTables")) {
            config.setProperty("worldTables", Arrays.asList("lb-main"));
        }
        if (!keys.contains("driver")) {
            config.setProperty("driver", (Object)"com.mysql.jdbc.Driver");
        }
        if (!keys.contains("url")) {
            config.setProperty("url", (Object)"jdbc:mysql://localhost:3306/db");
        }
        if (!keys.contains("username")) {
            config.setProperty("username", (Object)"user");
        }
        if (!keys.contains("password")) {
            config.setProperty("password", (Object)"pass");
        }
        if (!keys.contains("keepLogDays")) {
            config.setProperty("keepLogDays", (Object)-1);
        }
        if (!keys.contains("delay")) {
            config.setProperty("delay", (Object)6);
        }
        if (!keys.contains("defaultDist")) {
            config.setProperty("defaultDist", (Object)20);
        }
        if (!keys.contains("defaultTime")) {
            config.setProperty("defaultTime", (Object)"30 minutes");
        }
        if (!keys.contains("toolID")) {
            config.setProperty("toolID", (Object)270);
        }
        if (!keys.contains("toolblockID")) {
            config.setProperty("toolblockID", (Object)7);
        }
        if (!keys.contains("toolblockRemove")) {
            config.setProperty("toolblockRemove", (Object)true);
        }
        if (!keys.contains("logSignTexts")) {
            config.setProperty("logSignTexts", (Object)false);
        }
        if (!keys.contains("logExplosions")) {
            config.setProperty("logExplosions", (Object)false);
        }
        if (!keys.contains("logFire")) {
            config.setProperty("logFire", (Object)false);
        }
        if (!keys.contains("logChestAccess")) {
            config.setProperty("logChestAccess", (Object)false);
        }
        if (!keys.contains("logLeavesDecay")) {
            config.setProperty("logLeavesDecay", (Object)false);
        }
        if (!keys.contains("logTNTExplosionsAs")) {
            config.setProperty("logTNTExplosionsAs", (Object)"TNT");
        }
        if (!keys.contains("logCreeperExplosionsAs")) {
            config.setProperty("logCreeperExplosionsAs", (Object)"Creeper");
        }
        if (!keys.contains("logFireAs")) {
            config.setProperty("logFireAs", (Object)"Fire");
        }
        if (!keys.contains("logLeavesDecayAs")) {
            config.setProperty("logLeavesDecayAs", (Object)"LeavesDecay");
        }
        if (!keys.contains("usePermissions")) {
            config.setProperty("usePermissions", (Object)false);
        }
        if (!config.save()) {
            LogBlock.log.severe("[LogBlock] Error while writing to config.yml");
            return false;
        }
        worldNames = config.getStringList("worldNames", null);
        worldTables = config.getStringList("worldTables", null);
        dbDriver = config.getString("driver");
        dbUrl = config.getString("url");
        dbUsername = config.getString("username");
        dbPassword = config.getString("password");
        keepLogDays = config.getInt("keepLogDays", -1);
        delay = config.getInt("delay", 6);
        defaultDist = config.getInt("defaultDist", 20);
        defaultTime = LogBlock.parseTimeSpec(config.getString("defaultTime"));
        toolID = config.getInt("toolID", 270);
        toolblockID = config.getInt("toolblockID", 7);
        toolblockRemove = config.getBoolean("toolblockRemove", true);
        logSignTexts = config.getBoolean("logSignTexts", false);
        logExplosions = config.getBoolean("logExplosions", false);
        logFire = config.getBoolean("logFire", false);
        logChestAccess = config.getBoolean("logChestAccess", false);
        logLeavesDecay = config.getBoolean("logLeavesDecay", false);
        logTNTExplosionsAs = config.getString("logTNTExplosionsAs");
        logCreeperExplosionsAs = config.getString("logCreeperExplosionsAs");
        logFireAs = config.getString("logFireAs");
        logLeavesDecayAs = config.getString("logLeavesDecayAs");
        usePermissions = config.getBoolean("usePermissions", false);
        return true;
    }
}

